$Title: (4) Calculate AEZ-RB shares for crops

*       ----------------------------------------------------------------       *
*                                                                              *
*                       Global Trade Analysis Project                          *
*                            GTAP Water database                               *
*               (4)   Calculate AEZ-RB shares for crops                        *
*                                                                              *
*       ----------------------------------------------------------------       *

parameters
  shr_irr          vertical share parameter for irrigated production
  shr_rfd          vertical share parameter for rain fed production
;
hi('tot','_', c,r) = sum((a,b), hi(a,b,c,r));
hr('tot','_', c,r) = sum((a,b), hr(a,b,c,r));
qi('tot','_', c,r) = sum((a,b), qi(a,b,c,r));
qr('tot','_', c,r) = sum((a,b), qr(a,b,c,r));

*   (1)  Initial is zero
shr_irr(r,a,b,c) = eps;
shr_rfd(r,a,b,c) = eps;

*   (2) share based on land use database
shr_irr(r,a,b,c)$qi('tot','_', c,r) = qi(a,b,c,r)/qi('tot','_', c,r);
shr_rfd(r,a,b,c)$qr('tot','_', c,r) = qr(a,b,c,r)/qr('tot','_', c,r);

*   (3) If production of one product is zero
shr_irr(r,a,b,c)$(sum(crop, qi('tot','_', crop,r)) and not qi('tot','_', c,r)) =
     sum(crop, qi(a,b,crop,r))/sum(crop, qi('tot','_', crop,r));
shr_rfd(r,a,b,c)$(sum(crop, qr('tot','_', crop,r)) and not qr('tot','_', c,r)) =
     sum(crop, qr(a,b,crop,r))/sum(crop, qr('tot','_', crop,r));

*   (4) If no crop production
shr_irr(r,'aez9','rb500',c)$(not sum(crop, qi('tot','_', crop,r))) = 1;
shr_rfd(r,'aez9','rb500',c)$(not sum(crop, qr('tot','_', crop,r))) = 1;
